state EnergySpells in W3MagicVigil
{
	var damage_action			 						: W3DamageAction;
	var damage_value									: float;
	var actors 											: array<CActor>;
	var i												: int;
	var main_effect, effect_entity, effect_entity2		: CEntity;
	var target											: CActor; 
	var entities 										: array<CGameplayEntity>; 
	var position 										: Vector;
	var rotation 										: EulerAngles;
	var slotMatrix 										: Matrix;
	var energy_area   									: SpellsEnergyArea;
	var ents_destroy									: array< CEntity >;
	var duration										: float;
	var CustomEffect									: SCustomEffectParams;
	var castDir											: Vector;
	var targetPosition									: Vector;
	var fireball										: W3FireGnosisFireball;
	var boneRotation 									: EulerAngles;
	var bonePosition 									: Vector;
	var dummy											: CEntity;
	var dummy_proj                                      : W3EnergyDummy;
	var custom_anim										: name;
	var cast_hand										: CEntity;
	var vector_attach 									: Vector;
	var randRoll										: float;


	event OnEnterState( prevStateName : name )
	{
		if ( !theSound.SoundIsBankLoaded("amb_dyn_bob_electric_cage.bnk") )
		{
			theSound.SoundLoadBank( "amb_dyn_bob_electric_cage.bnk", false );
		}
		if ( !theSound.SoundIsBankLoaded("magic_keira.bnk") )
		{
			theSound.SoundLoadBank( "magic_keira.bnk", false );
		}
		if ( !theSound.SoundIsBankLoaded("magic_sorceress.bnk") )
		{
			theSound.SoundLoadBank( "magic_sorceress.bnk", false );
		}
		if ( !theSound.SoundIsBankLoaded("ep2_setbonus_gryphon.bnk") )
		{
			theSound.SoundLoadBank( "ep2_setbonus_gryphon.bnk", false );
		}
		if ( !theSound.SoundIsBankLoaded("monster_cloud_giant.bnk") )
		{
			theSound.SoundLoadBank( "monster_cloud_giant.bnk", false );
		}
	
		if ( parent.act_signtype == ST_Axii )
		{
			if ( parent.actor && parent.actor.IsAlive() )
			{
				thePlayer.SetSlideTarget( parent.actor );
			}
			else
			{
				thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
			}
		}
		else
		if ( !theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'cast_to_camera') )
		{
			if ( !GetMagicVigil().IsAlt() )
			{
				if ( parent.actor && parent.actor.IsAlive() )
				{
					thePlayer.SetSlideTarget( parent.actor );
				}
				else
				{
					thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
				}
			}
		}
		else
		{
			thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
		}
		
		if ( parent.alternate )
		{
			thePlayer.PushState( 'camera_hack' );     
		}
		
		cast_spells_axii_energy_init();
	}
	
	event OnCastSpellAnimation( animEventName : name, animEventType : EAnimationEventType, animInfo : SAnimationEventAnimInfo )
	{
		if ( animEventName == 'cast_begin' )
		{
		}
		else if ( animEventName == 'cast_throw' )
		{
			cast_spells_energy();
			thePlayer.RemoveCustomOrientationTarget( 'MagicSpells' );
		}
		else if ( animEventName == 'cast_end' )
		{
			cast_spells_axii_energy();
			parent.GotoState( 'Vigil_Dreaming' );
		}
	}
	
	private function cast_spells_energy()
	{
		switch( parent.spell_name )
		{
			case 'energy_circle':
				{
					theGame.GetEntitiesByTag('energy_area_spells',ents_destroy);
					for( i=0; i<ents_destroy.Size(); i+=1 )
					{
						ents_destroy[i].AddTimer('destroy_energy_area',0.0f);
					} 	
						
					thePlayer.CalcEntitySlotMatrix('l_weapon', slotMatrix);
					position = MatrixGetTranslation(slotMatrix);
					rotation = thePlayer.GetWorldRotation();
					
					duration = 10;
					duration += duration * ( GetMagicVigil().get_magic_spellpower() * 0.5 );
					
					parent.templatename = "dlc\magicspellsrev\data\entities\energy_area.w2ent";
						
					energy_area = (SpellsEnergyArea)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), TraceFloor( position ), rotation );
					energy_area.AddTimer('destroy_energy_area', duration );
					energy_area.AddTag('energy_area_spells');
					energy_area.AddTag( 'spells_from_sign' );
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				}

				break;
			case 'energy_shield':
				{
					clear_guarding_buffs( false );
				
					CustomEffect.effectType = EET_Energyshield;
					CustomEffect.creator = GetWitcherPlayer();
					CustomEffect.duration = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( parent.signskill, 'shield_duration', true, true) );
					GetWitcherPlayer().AddEffectCustom( CustomEffect );
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				}

				break;
			case 'energy_cone':
				{
					thePlayer.CalcEntitySlotMatrix('l_weapon', slotMatrix);
					position = MatrixGetTranslation(slotMatrix);
					rotation = thePlayer.GetWorldRotation();
						
					castDir 		= MatrixGetAxisX( slotMatrix );
					castDir.Z 		= ClampF( castDir.Z, 0, 10 );
					targetPosition 	= position + ( 5 * castDir );
						
					parent.hand_aim_position = position;
					parent.hand_aim_direction = castDir;
					
					parent.templatename = "dlc\magicspellsrev\data\entities\energy.w2ent";
					
					rotation.Yaw += 90;
						
					effect_entity2 = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), position, rotation );
					effect_entity2.PlayEffect('energy_cone2');
					effect_entity2.DestroyAfter(10);	
						
						
					randRoll = RandRangeF( 180.0, -180.0 );
					rotation.Pitch = randRoll;
					
					
					main_effect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), position, rotation );
					main_effect.PlayEffect('energy_cone'); 
					main_effect.DestroyAfter(10);
					
					if ( RandF() <= 0.5 )
					{	rotation.Pitch += RandRange( 18, 3 ) * 10;	}
					else
					{	rotation.Pitch -= RandRange( 18, 3 ) * 10;	}
					
					effect_entity = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), position, rotation );
					effect_entity.PlayEffect('energy_cone1');
					effect_entity.DestroyAfter(10);
					
					dummy_proj = (W3EnergyDummy)theGame.CreateEntity( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\energy_dummy_projectile.w2ent",true ), position );
					dummy_proj.AddTag( 'spells_custom_projs' );
					dummy_proj.Init(NULL);
					dummy_proj.ShootProjectileAtPosition(0,	15, targetPosition, 11 );
					dummy_proj.DestroyAfter(10);
					
					main_effect.SoundEvent("sign_yrden_shock_activate");
					main_effect.SoundEvent("magic_sorceress_vfx_lightning_bolt");
			
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				}
				
				break;
			case 'energy_stream':
				{
					parent.stamina_cost = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( parent.signskill, 'stamina_cost_per_sec', false, true ) * 0.5 );
					parent.stamina_cost += parent.stamina_cost * get_stamina_cost_mult_streams(); 
					
					parent.stamina_delay = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( parent.signskill, 'stamina_delay', false, true ) );
					parent.stamina_delay += parent.stamina_delay * get_stamina_delay_mult(); 
					
					register_cancel_input_spells();
					
					cast_spells_stream_energy();
				}
				
				break;
			default:		
				break;
		}
	}
	
	private entry function cast_spells_axii_energy_init()
	{
		var effect0			: CEntity;
		
		if ( parent.spell_name == 'energy_lightning' || parent.spell_name == 'energy_cone' || parent.spell_name == 'energy_circle' )
		{
			
			vector_attach = Vector( 0.2, 0.00, 0.00 );
			effect0 = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( 'spells_energy_effects'), position );
			effect0.CreateAttachment( GetMagicEffectLeft(),, vector_attach );
			effect0.PlayEffectSingle('electricity_hand');
			effect0.StopAllEffects();
			effect0.DestroyAfter(2);
			
			effect0 = thePlayer.CreateFXEntityAtBone( 'spells_energy_effects', 'l_middle1', true );
			effect0.PlayEffectSingle('electricity_hand');
			effect0.StopAllEffects();
			effect0.DestroyAfter(2);
			
			/*
			vector_attach = Vector( 0.4, -0.1, 0.00 );
			effect0 = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( 'spells_energy_effects'), position );
			effect0.CreateAttachment( GetMagicEffectLeft(),, vector_attach );
			effect0.PlayEffectSingle('electricity_hand');
			effect0.StopAllEffects();
			effect0.DestroyAfter(2);
			*/
			
			if ( parent.spell_name == 'energy_lightning' || parent.spell_name == 'energy_cone' )
			{
				thePlayer.SoundEvent("sign_yrden_warmup");
			}
			if ( parent.spell_name == 'energy_cone' )
			{
				thePlayer.SoundEvent("sign_yrden_warmup");
			}
		}
	}
	private function cast_spells_axii_energy()
	{
		var venom						: W3GreatSwampVenom;
		var effect1,effect2				: CEntity;
		var elactors					: array<CActor>;
		var elactor0,elactor1			: CActor;
	
		if ( parent.spell_name == 'energy_lightning' )
		{
			if ( parent.actor && parent.actor.IsAlive() && IsRequiredAttitudeBetween(thePlayer, parent.actor, true, false, false) )
			{
				/*
				vector_attach.X = StringToFloat( theGame.GetInGameConfigWrapper().GetVarValue( 'magic_spells_main', 'debug_pos_x' ) );
				vector_attach.Y = StringToFloat( theGame.GetInGameConfigWrapper().GetVarValue( 'magic_spells_main', 'debug_pos_y' ) );
				vector_attach.Z = StringToFloat( theGame.GetInGameConfigWrapper().GetVarValue( 'magic_spells_main', 'debug_pos_z' ) );
				*/
				
				vector_attach = Vector( -0.35, 0.08, -0.05 );
				
				
				effect1 = parent.actor.CreateFXEntityAtPelvis( 'spells_energy_effects', true );				
				
				//main_effect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( 'spells_energy_effects' ), position );
				//main_effect.CreateAttachment( thePlayer, 'l_weapon', vector_attach );
				main_effect = thePlayer.CreateFXEntityAtBone( 'spells_energy_effects', 'l_middle1', true );
				
				
				effect2 = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( 'spells_energy_effects'), position );
				effect2.CreateAttachment( thePlayer, 'l_weapon', vector_attach );
				effect2.PlayEffectSingle('electricity_hand_shot');
				effect2.DestroyAfter(3);
				
				main_effect.PlayEffect('energy_lightning', effect1 );
				main_effect.DestroyAfter(3);
				effect1.PlayEffectSingle('energy_hit_effect2');
				effect1.SoundEvent("sign_yrden_shock_activate");
				effect1.StopAllEffects();
				effect1.DestroyAfter(5);
				
				
				if ( RandF() <= 0.25 )
				{
					elactors = parent.actor.GetNPCsAndPlayersInRange(20, 20, ,FLAG_ExcludePlayer + FLAG_OnlyAliveActors );
					for (i=0; i<elactors.Size(); i+=1)
					{
						if ( IsRequiredAttitudeBetween(thePlayer, elactors[i], true, false, false) )
						{
							elactor0 = elactors[i-1];
							elactor1 = elactors[i];
							
							if ( i != 0 && elactors.Size() >1 )
							{
								effect1 = elactor0.CreateFXEntityAtPelvis( 'spells_energy_effects', true );				
								effect2 = elactor1.CreateFXEntityAtPelvis( 'spells_energy_effects', true );				
										
									effect1.PlayEffect('energy_lightning', effect2 );
									effect1.SoundEvent("sign_yrden_shock_activate");
									effect1.DestroyAfter(3);
									effect2.PlayEffectSingle('energy_hit_effect2');
									effect2.StopAllEffects();
									effect2.DestroyAfter(5);
							}
							energy_lighting_damage( elactor1 );
						}
					}
				}
				else
				{
					energy_lighting_damage( parent.actor );
				}
				
				thePlayer.SoundEvent("sign_yrden_shock_activate");
				
				Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				
				thePlayer.SetCombatIdleStance( 1.f );
			}
		}
	}
	
	function energy_lighting_damage( target : CActor )
	{
		damage_value = get_damage_value_for_projectile( target, GetMagicVigil().get_magic_spellpower() );
		
		damage_action =  new W3DamageAction in this;
		damage_action.Initialize(thePlayer,target,thePlayer,thePlayer.GetName()+"_sign",EHRT_None,CPS_Undefined,false, false, true, false );
		damage_action.SetProcessBuffsIfNoDamage(true);
		damage_action.SetHitReactionType(EHRT_Heavy);
		damage_action.SetHitEffect('');
		damage_action.SetHitEffect('', true );
		damage_action.SetHitEffect('', false, true);
		damage_action.SetHitEffect('', true, true);
		damage_action.SetHitAnimationPlayType(EAHA_Default);
		
		damage_action.AddDamage( theGame.params.DAMAGE_NAME_SHOCK, sp_shock_dmg_mod() * damage_value );
		
		if ( spells_can_dismember( target ) )
		{
			damage_action.SetForceExplosionDismemberment();
		}
		
		theGame.damageMgr.ProcessAction( damage_action );
		delete damage_action;
		
		if( !target.IsAlive() )
		{
			target.PlayEffect('hit_electric');
		}
		
		//theGame.witcherLog.AddMessage("energy_lighting_damage: " + damage_value );
	}
	
	
	
	
	private entry function cast_spells_stream_energy()
	{
		var damage_action_stream				: W3DamageAction;
		var victims 							: array<CActor>;
		var victim								: CActor;
		var damage 								: float;
		var i									: int;
		var castDir								: Vector;
		var targetPosition						: Vector;
		var position							: Vector;
		var slotMatrix 							: Matrix;
		var effectentity, eff0, eff1, main		: CEntity;
		var coll, normal 						: Vector;
		var lastpos 							: Vector;
		var entities							: array<CGameplayEntity>;
		var lastpos2 							: Vector;
		var target_stream						: CEntity;		 
		var	timestamp							: float;
		var results 							: array<SRaycastHitResult>;
		var res, effect_expl					: CEntity;
		var ind 								: int;
		var min 								: float;
		var effectsound, effectsound1			: CEntity;
	
		vector_attach = Vector( 0.2, 0.00, 0.00 );
		eff0 = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( 'spells_energy_effects'), position );
		eff0.CreateAttachment( GetMagicEffectLeft(),, vector_attach );
		eff0.PlayEffectSingle('electricity_hand_stream');
		eff0.AddTag('spells_alt_stream');	
		
		eff1 = thePlayer.CreateFXEntityAtBone( 'spells_energy_effects', 'l_middle1', true );
		eff1.PlayEffectSingle('electricity_hand_stream');
		eff1.AddTag('spells_alt_stream');	
		
		main = thePlayer.CreateFXEntityAtBone( 'spells_energy_effects', 'l_middle1', true );
		main.AddTag('spells_alt_stream');
	
		effectentity = theGame.CreateEntity( (CEntityTemplate)LoadResource("dlc\magicspellsrev\data\entities\energy_stream_collision.w2ent",true), targetPosition, thePlayer.GetWorldRotation() );
		effectentity.AddTag('spells_stream_collision');
		
		effectsound = theGame.CreateEntity( (CEntityTemplate)LoadResource("dlc\magicspellsrev\data\entities\energy_body_electricity.w2ent",true), targetPosition, thePlayer.GetWorldRotation() );
		effectsound.SoundEvent("monster_cloud_giant_fx_lightning_begin");
		effectsound.AddTag('spells_stream_collision_sound');
		
		effectsound1 = theGame.CreateEntity( (CEntityTemplate)LoadResource("dlc\magicspellsrev\data\entities\energy_body_electricity.w2ent",true), thePlayer.GetWorldPosition() );
		effectsound1.SoundEvent("magic_keira_hand_fx_electricity_loop_start");
		effectsound1.CreateAttachment( GetMagicEffectLeft() );
		effectsound1.AddTag('spells_stream_collision_sound1');
		
		while ( true )
		{
			if ( thePlayer.GetStatPercents( BCS_Stamina ) > 0.01f && thePlayer.GetBehaviorVariable	( 'IsCastingSign' ) == 1 )
			{
				thePlayer.CalcEntitySlotMatrix('l_weapon', slotMatrix);
				position = MatrixGetTranslation(slotMatrix);
				
				castDir 		= MatrixGetAxisX( thePlayer.GetBoneWorldMatrixByIndex( thePlayer.GetBoneIndex( 'l_weapon' ) ) );
				targetPosition  = position + ( 40 * castDir );
				
				parent.hand_aim_position = position;
				parent.hand_aim_direction = castDir;
			
				results.Clear();
				FindActorsAtLine( position, targetPosition, 0.1f, results );
				
				if ( results.Size() > 0 )
				{
					min = results[0].distance;
					ind = 0;
					for( i=1; i<results.Size(); i+=1 )
					{
						if(results[i].distance < min)
						{
							min = results[i].distance;
							ind = i;
						}
					}
				}
				
				if(results[ind].component)
				{
					res = results[ind].component.GetEntity();
					victim = (CActor)res;
			
					if ( GetAttitudeBetween( victim, thePlayer ) == AIA_Hostile && victim.IsAlive() )
					{
						damage = get_damage_value_for_stream( victim, GetMagicVigil().get_magic_spellpower() );
						damage *= theTimer.timeDelta;
					
						damage_action_stream = new W3DamageAction in this;
						damage_action_stream.Initialize(thePlayer,victim,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_SpellPower,false, false, true, false );
						damage_action_stream.SetProcessBuffsIfNoDamage(true);
						
						if ( ( (CNewNPC)victim ).IsShielded( thePlayer ) )
						{
							damage *= 0.5;
						
							if ( ( (CNewNPC)victim ).GetBehaviorVariable( 'bShieldUp' ) == 0.f )
							{
								( (CNewNPC)victim ).SetBehaviorVariable( 'bShieldUp', 1.f );
							}
							
							if ( ( (CNewNPC)victim ).GetStaminaPercents() > 0.1 )
							{
								( (CNewNPC)victim ).DrainStamina(ESAT_FixedValue, 5 );
							}
							else 
							{
								( (CNewNPC)victim ).ProcessShieldDestruction();
							}
						}
						else
						{
							if( RandF()<0.1 ) 
							{ 
								damage_action_stream.AddEffectInfo( EET_SpellsSlowDownCritical, 1 ); 
							}
						}
						
						damage_action_stream.AddDamage(theGame.params.DAMAGE_NAME_SHOCK, sp_shock_dmg_mod() * damage );
						damage_action_stream.AddEffectInfo( EET_SpellsSlowDownAverage, 1 );
						damage_action_stream.SetIsDoTDamage( theTimer.timeDelta );
						damage_action_stream.SetHitAnimationPlayType(EAHA_Default);
						
						damage_action_stream.SetHitEffect('');
						damage_action_stream.SetHitEffect('', true );
						damage_action_stream.SetHitEffect('', false, true);
						damage_action_stream.SetHitEffect('', true, true);
					
						
						if ( spells_can_dismember( victim ) )
						{
							damage_action_stream.SetForceExplosionDismemberment();
						}
						
						theGame.damageMgr.ProcessAction( damage_action_stream );
						delete damage_action_stream;
						
						if( !victim.IsAlive() )
						{
							effect_expl = victim.CreateFXEntityAtPelvis( 'explosions', true );
							effect_expl.PlayEffect( 'explosion_energy' );
							effect_expl.DestroyAfter(5);
							effect_expl.SoundEvent("magic_keira_lightning");
						}
					}
				}
				
				if( theGame.GetWorld().SweepTest( position + castDir, targetPosition, 0.1, coll, normal, parent.collisions_stream ) )
				{
					lastpos = coll;
					theGame.GetEntityByTag( 'spells_stream_collision' ).PlayEffect('collision_fx');
					theGame.GetEntityByTag( 'spells_stream_collision' ).Teleport(lastpos);
					theGame.GetEntityByTag( 'spells_stream_collision_sound' ).Teleport(lastpos);
				}
				else
				{
					theGame.GetEntityByTag( 'spells_stream_collision' ).StopEffect('collision_fx');
					theGame.GetEntityByTag( 'spells_stream_collision' ).Teleport(targetPosition);
					theGame.GetEntityByTag( 'spells_stream_collision_sound' ).Teleport(targetPosition);
				}
				
				if ( ( EngineTimeToFloat( theGame.GetEngineTime() ) - timestamp ) > 0.15 )
				{
					timestamp = EngineTimeToFloat( theGame.GetEngineTime() );
					main.PlayEffect('energy_lightning_stream', theGame.GetEntityByTag( 'spells_stream_collision' ) );
					//main.PlayEffect('energy_lightning_stream', theGame.GetEntityByTag( 'spells_stream_collision' ) );
				}
				
				GetWitcherPlayer().DrainStamina( ESAT_FixedValue, parent.stamina_cost * theTimer.timeDelta, parent.stamina_delay ); 
			}
			else
			{
				thePlayer.SoundEvent("gui_no_stamina");
				parent.PushState('Vigil_Dreaming');
			}
			
			Sleep( theTimer.timeDelta );
		}
	
	}
	
	event OnLeaveState( nextStateName : name )
	{
	}
}